import {Component} from 'angular2/core';
import {Hero} from './hero';
import {HeroDetailComponent} from './hero-detail.component';

@Component({
    selector: 'my-app',
    template: `
       <h4>{{title}}</h4>
       <my-hero-detail [hero]="selectedHero"></my-hero-detail>
            <h2>可选列表</h2>
          
	       <ul class="heroes">
                <li *ngFor="#hero of heroes" 
                    [class.selected]="hero === selectedHero"  
                    (click)="onSelect(hero)"> 
                    <span class="badge">{{hero.id}}</span> {{hero.name}}
                </li>
            </ul>
          `,
    styles:[`
        .heroes {list-style-type: none; margin-left: 1em; padding: 0; width: 10em;}
        .heroes li { cursor: pointer; position: relative; left: 0; transition: all 0.2s ease; }
        .heroes li:hover {color: #369; background-color: #EEE; left: .2em;}
        .heroes .badge {
        font-size: small;
        color: white;
        padding: 0.1rem 0.7em;
        background-color: #369;
        line-height: 1rem;
        position: relative;
        left: -1px;
        top: -1px;
        }
	em{
	font-size:0.8rem;}
        .selected { background-color: #EEE; color: #369; }
    `]，
    directives: [HeroDetailComponent]
})
export class AppComponent { 
    public title = '抽签算卦';
    public hero: Hero = {
        id: 1,
        name: '吕氏灵签',
	desc:'仅为娱乐，无其它参考意义'
    };
     public heroes = HEROES;

     public selectedHero: Hero;
    onSelect(hero: Hero) { this.selectedHero = hero; }
}
     var HEROES: Hero[] =  [
     {id: 1,
        name: '上上',
	desc:'大吉大利，百事顺遂,赶紧去买彩票'},
	{id: 2,
        name: '上吉',
	desc:'天时、地利又人和，家庭和睦，身体健康，会朋友喝酒吧'},
	{id: 3,
        name: '中吉',
	desc:'苦尽甘来，风雨之后见彩虹，要转好运了'},
	{id: 4,
        name: '中平',
	desc:'黎明前的曙光。寓象中不是“怀才不遇”，而是“怀才待遇”。多嘱求者“一动不若一静”。无大喜亦无大悲。在这五种签意中，最欣赏的还是中平签，因为它更符合百姓，贴近生活。其不似“上上”般如中头彩；不似“上吉”般天时、地利又人和；不似“中吉”般起起落落，如咖啡加糖；“中平”更多的是人们常求的“平平”和“淡淡”。'},
	{id: 5,
        name: '下下',
	desc:'凶多吉少.否极泰来，物极必反,再熬一熬就过去了。要不再抽一签？'}
	
	] ;
