import {Component, OnInit} from 'angular2/core';
import {Hero} from './hero';
import {HeroDetailComponent} from './hero-detail.component';
import {ClickMeComponent } from './click-me.component'；
import {KeyUpComponent} from './keys-up.component'；
import {LoopbackComponent} from './loopback.component'；
import {KeyUpComponent_v2} from './keyup2.component'；
import {HeroService} from './hero.service';

@Component({
    selector: 'my-app',
    template: `
       <h4>{{title}}</h4>
       <h2>点击事件</h2>
    <click-me></click-me>
    <h2>key up 事件</h2>
    <key-up></key-up>
    <h2>请输入名字：</h2>
    <loopback></loopback>
    <h2>keyup和loopback的结合使用</h2>
<key-up2></key-up2>
       <my-hero-detail [hero]="selectedHero"></my-hero-detail>
            <h2>可选列表</h2>
          
	       <ul class="heroes">
                <li *ngFor="#hero of heroes" 
                    [class.selected]="hero === selectedHero"  
                    (click)="onSelect(hero)"> 
                    <span class="badge">{{hero.id}}</span> {{hero.name}}
                </li>
            </ul>
          `,
    styles:[`
        .heroes {list-style-type: none; margin-left: 1em; padding: 0; width: 10em;}
        .heroes li { cursor: pointer; position: relative; left: 0; transition: all 0.2s ease; }
        .heroes li:hover {color: #369; background-color: #EEE; left: .2em;}
        .heroes .badge {
        font-size: small;
        color: white;
        padding: 0.1rem 0.7em;
        background-color: #369;
        line-height: 1rem;
        position: relative;
        left: -1px;
        top: -1px;
        }
	em{
	font-size:0.8rem;}
        .selected { background-color: #EEE; color: #369; }
    `]，
    directives: [HeroDetailComponent，ClickMeComponent,LoopbackComponent，KeyUpComponent,KeyUpComponent_v2],
    
    providers: [HeroService]
})
export class AppComponent implements OnInit {
    public title = '抽签算卦';
    public heroes: Hero[];
  public selectedHero: Hero;
   constructor(private _heroService: HeroService) { }
  getHeroes() {
    this._heroService.getHeroes().then(heroes => this.heroes = heroes);
  }
  ngOnInit() {
    this.getHeroes();
  }
  onSelect(hero: Hero) { this.selectedHero = hero; }

    public hero: Hero = {
        id: 1,
        name: '吕氏灵签',
	desc:'仅为娱乐，无其它参考意义'
    };
   
}
    
